//
//  Sprite.m
//  Engine
//
//  Created by ss2cire on 10/9/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "Sprite.h"


@implementation Sprite
- (id)initWithLocationX:(int)locX locationY:(int)locY andSize:(NSSize)inSize
{
	self = [super init];
	if(self != nil)
	{
		locationX = locX;
		locationY = locY;
		size = inSize;
		textureID = 0;
		hasTexture = NO;
	}
	return self;
}

- (void)dealloc
{
	locationX = 0;
	locationY = 0;
	size = NSZeroSize;
	textureID = 0;
	hasTexture = NO;
	[super dealloc];
}

- (void)setTexture:(GLuint)newID
{
	textureID = newID;
	if(textureID != 0) {
		hasTexture = YES;
	} else {
		hasTexture = NO;
	}
}

- (void)draw
{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textureID);

	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex2f(locationX,     locationY);

		glTexCoord2f(0.0, 0.0);
		glVertex2f(locationX, locationY + size.height);

		glTexCoord2f(1.0, 0.0);
		glVertex2f(locationX + size.width, locationY + size.height);

		glTexCoord2f(1.0, 1.0);
		glVertex2f(locationX + size.width, locationY);	
	glEnd();
	glDisable(GL_TEXTURE_2D);
}

- (void)update
{
}
@end
